﻿<?php 
/**
 * Admin Notes v1.0  
 * Copyright © 2011 Edson Ordaz
 *
 * Website: http://www.mybb-es.com
 *
 */

function adminnotes_info()
{
	return array(
		"name"			=> "ملاحظات الادارة",
		"description"	=> "يقوم بحفظ الملاحظات وتقدر تضع اكثر من ملاحظة",
		"website"		=> "http://www.mybb-es.com/",
		"author"		=> "Edson Ordaz",
		"authorsite"	=> "mailto:nicedo_eeos@hotmail.com",
		"version"		=> "1.0",
		"guid"			=> "02b6306b2f675ec63a5bb193158af7ac",
		"compatibility" => "*"
	);
}

function adminnotes_is_installed(){
	global $mybb, $db;
  	if($db->table_exists("adminnotes"))
	{
		return true;
	}
}

function adminnotes_install()
{
	global $db;
	if(!$db->table_exists("adminnotes"))
	{
		$db->query("CREATE TABLE IF NOT EXISTS `".TABLE_PREFIX."adminnotes` (
		  `nid` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
		  `uid` varchar(120) NOT NULL DEFAULT '',
		  `text` text NOT NULL DEFAULT '',
		  PRIMARY KEY (`nid`)
		) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;");
	}
	$adminnotes_groups = array(
		"gid"			=> "NULL",
		"name"			=> "adminnotes",
		"title" 		=> "ملاحظات الادارة",
		"description"	=> "حفظ ملاحظات الادارة",
		"disporder"		=> "0",
		"isdefault"		=> "no",
	);
	$db->insert_query("settinggroups", $adminnotes_groups);
	$gid = $db->insert_id();
	$adminnotes = array(
		array(
			"name"			=> "adminnotes_pagination",
			"title"			=> "عدد الملاحظات بالصفحة ",
			"description"	=> "عدد الملاحظات الذي يظهر في كل صفحة ",
			"optionscode"	=> "text",
			"value"			=> "15",
			"disporder"		=> 1,
			"gid"			=> $gid,
		)
	);
	foreach($adminnotes as $adminnotesinstall)
	$db->insert_query("settings", $adminnotesinstall);
	rebuildsettings();
}

function adminnotes_uninstall()
{
	global $db;
	$db->drop_table("adminnotes");
	$db->query("DELETE FROM ".TABLE_PREFIX."settinggroups WHERE name='adminnotes'");
	$db->delete_query("settings","name LIKE 'adminnotes_%'");
}
?>